<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package physioplus
 */

get_header(); ?>
<div class="main-container"><!--main-container-->
	<div class="container">
		<div class="row">
            <?php 
			if ( is_active_sidebar( 'sidebar-1' ) ) { $col_class="col-md-8";} else { $col_class="col-md-12"; }
			?>
            <div class="<?php echo $col_class;?> content-left"><!--content left-->
                <div class="row">
                <?php
                while ( have_posts() ) : the_post();
        
                    get_template_part( 'template-parts/content','single' );
        
                    // related post 
                    physioplus_related_post();
                    
                    //  single post prev and next post display
                    physioplus_single_post_pre_next();
        
                    // author bio
                    get_template_part( 'author-bio' );
        
                    // If comments are open or we have at least one comment, load up the comment template.
                    if ( comments_open() || get_comments_number() ) :
                        comments_template();
                    endif;
        
                endwhile; // End of the loop.
                ?>
                </div>
            </div>    
            <?php if ( is_active_sidebar( 'sidebar-1' ) ) { ?>
            <div class="col-md-4 sidebar"><!--sidebar-->
                    <?php dynamic_sidebar( 'sidebar-1' ); ?>
            </div>
            <?php } ?>
        	<!-- /.sidebar-->              
		</div><!--/.row -->
	</div><!--/. container-->
</div>
<?php
get_footer();
?>
