<?php
/**
 * The template for displaying all Doctor posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package physioplus
 */

get_header(); ?>
<div class="main-container">   <!--main-container-->
    <div class="container">
      <div class="row">
		<?php while ( have_posts() ) : the_post(); ?>
        <div class="col-md-12">
            <?php the_content(); ?>
        </div>
        <div class="popup-gallery">
            <?php
			$gallery_data = get_post_meta( $post->ID, 'gallery_data', true );
			
			if ( isset( $gallery_data['image_title'] ) ) 
			{
				for( $i = 0; $i < count( $gallery_data['image_title'] ); $i++ ) 
				{
				?>
                <div class="col-md-4 gallery-block"><!--Project block start-->
                    <div class="gallery-thumb zoom-pic"><!--Pro thumb start--> 
                      <a href="<?php echo esc_url($gallery_data['single_image_url'][$i]); ?>" class="image-link" title="<?php echo esc_attr($gallery_data['image_title'][$i]); ?>"> <img src="<?php echo esc_url($gallery_data['single_image_url'][$i]); ?>"  alt="<?php echo esc_attr($gallery_data['image_title'][$i]); ?>" class="img-responsive"/> </a> </div>
                    <!--Pro thumb start--> 
                </div>                
                <?php 
				}
			}
            ?>
          </div>
        <?php endwhile; // End of the loop. ?>
      </div>
    </div>
</div><!-- /.main-container-->
<?php get_footer(); ?>