<?php
/**
 *  Template Name: Pricing
 *
 * @package physioplus
 */

get_header(); 

$currency_code=thegenius_get_option('currency_symbols'); 
?>
<div class="main-container"><!-- main-container -->
  <div class="container">
		<?php while ( have_posts() ) : the_post(); ?>
        <div class="row">
	        <div class="col-md-12 mbtm-2">
    		    <?php the_content(); ?>
        	</div>
        </div>
        <?php endwhile; // End of the loop. ?>    
        
    <div class="row">
      	<?php 
        $args = array( 'post_type' => 'service', 'posts_per_page' => -1,'orderby' => 'menu_order ID','order'   => 'ASC' );
        $service = new WP_Query( $args );
        while ( $service->have_posts() ) : $service->the_post();

        //get the saved meta as an array of pricing
		$pricing = get_post_meta($post->ID,'pricing',true); 

		$service_price_description = get_post_meta($post->ID,'service_price_description',true); 
		$service_price_extra_note = get_post_meta($post->ID,'service_price_extra_note',true); 					
        ?>
		<div class="col-md-12 pricing-block"><!-- pricing-block -->
            <div class="row">
              <div class="col-md-4 pricing-desc"><!-- pricing-desc -->
                <h2><?php the_title(); ?></h2>
                <p><?php echo wp_kses_post($service_price_description);?></p>
                <?php 
                if(thegenius_get_option('general_check_appnt_btn')!=""){
                    echo '<a href="'.esc_url(thegenius_get_option('general_appnt_btn_url')).'" class="btn btn-default hvr-sweep-to-right">'.thegenius_get_option('general_appnt_btn_text').'</a>';
                }
                ?>         
                </div>
              <!-- pricing-desc -->
              <div class="col-md-offset-1 col-md-7 pricing-table"><!-- pricing-table -->
            <?php 
            if ( count( $pricing ) > 1) {
              echo '<ul class="list-group"><li class="list-group-item active">'.esc_html__('Treatments','physioplus').'<span class="pull-right price">'.esc_html__('Prices','physioplus').'</span></li>';
                foreach( $pricing as $consult_pricing ) {
                    if ( isset( $consult_pricing['consult'] ) || isset( $consult_pricing['cost'] ) ) {
                        
                        if(!empty($consult_pricing['time']))
                        {
                            $consult_time='('.$consult_pricing['time'].')';
                        }
                        else
                        {
                            $consult_time='';
                        }
                        echo '<li class="list-group-item">'.$consult_pricing['consult'].'<small>'.$consult_time.'
                        </small><span class="pull-right price">'.$currency_code.$consult_pricing['cost'].'</span></li>';
                    }
                }
                if($service_price_extra_note)
                {
                    echo '<li class="list-group-item"><span class="note">*'.esc_html__('Note','physioplus').' :'.$service_price_extra_note.'</span></li>';	
                }
                echo '</ul>';	
            } 
            ?>              
              </div>
              <!-- /.pricing-table --> 
            </div>
      	</div>        
        <?php
		endwhile; 		
		wp_reset_postdata();		
		?>    
      </div>    
  </div>
</div>
<?php get_footer(); ?>