<?php
/**
 *  Template Name: Branches
 *
 * @package physioplus
 */

get_header(); 

while ( have_posts() ) : the_post(); 
?>
<div class="main-container"><!-- main-container -->
  <div class="container">
    <div class="row">
      <div class="col-md-12">
	      <?php the_content(); ?>
      </div>
    </div>
    <div class="row">
      <div class="col-md-12 location-map">
        <div id="googleMap"> </div>
      </div>
    </div>
    <div class="row">
        <?php 
		$i=1;
		$branches_html='';
		$google_map_arr='';
		$args = array( 'post_type' => 'branches', 'posts_per_page' => -1,'orderby' => 'menu_order ID','order' => 'ASC' );
		$branches = new WP_Query( $args );
		$total_element=count($branches->posts);
		while ( $branches->have_posts() ) : $branches->the_post();

        $branches_address = get_post_meta( $post->ID, 'branches_address', true );
        $branches_email = get_post_meta( $post->ID, 'branches_email', true );
        $branches_phone = get_post_meta( $post->ID, 'branches_phone', true );

		$locators = get_post_meta( $post->ID, 'locators', true );

        $branches_longitude = $locators['longitude'];
        $branches_latitude = $locators['latitude'];
		$branches_html.= '<div class="col-md-4 location-block">';
		$branches_html.= '<div class="well-block"><h2>'.get_the_title().'</h2>';
		
		$branches_html.= '<div class="contact-information">';
		
		if(isset($branches_address))
		{
			$branches_html.='<div class="address-block"><div class="icon"><i class="flaticon-big104"></i></div><p>'.$branches_address.'</p></div>';
		}

		if(isset($branches_email))
		{
			$branches_html.='<div class="email-block"><div class="icon"><i class="flaticon-opened25"></i></div><p><a href="mailto:'.$branches_email.'">'.$branches_email.'</p></a></div>';				
		}
		if(isset($branches_phone))
		{
			$branches_html.='<div class="call-block"><div class="icon"><i class="flaticon-cellphone55"></i></div><p>'.$branches_phone.'</p></div>';				
		}		
		
		$branches_html.='<a class="btn btn-primary hvr-sweep-to-right btn-sm" href="'.get_permalink().'">'.esc_html__('View Details','physioplus').'</a>';

		$branches_html.='</div>';
		$branches_html.='</div>';	
		$branches_html.='</div>';	
		
		if(($i%3)==0 && $i<$total_element)
		{
			$branches_html .=  '</div><div class="row">';
		}	
		
		$google_map_arr.='["'.get_the_title().'", '.$branches_latitude.', '.$branches_longitude.','.$i++.'],';	
		endwhile; 		
		wp_reset_postdata();
		echo wp_kses_post($branches_html);
		?> 
        </div>
  </div>
</div>
<script>
// Data for the markers consisting of a name, a LatLng and a zIndex for the
// order in which these markers should display on top of each other.
var beaches = [<?php echo wp_kses_post($google_map_arr); ?> ];
var marker_img = '<?php echo get_template_directory_uri(); ?>/images/marker.png';
var center_point =   {"lat":<?php echo thegenius_get_option('branches_center_point_lat'); ?>,"lng":<?php echo thegenius_get_option('branches_center_point_lng'); ?>};
</script>
<?php
endwhile; // End of the loop. ?>
<?php get_footer(); ?>