<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package physioplus
 */

get_header(); ?>
<div class="main-container">
    <div class="container">
    <div class="row">
            <?php 
			if ( is_active_sidebar( 'sidebar-1' ) ) { $col_class="col-md-8";} else { $col_class="col-md-12"; }
			?>
        <div class="<?php echo $col_class;?> content-left"><!-- content left -->
            <div class="row">
                <?php if ( have_posts() ) :  ?>
                <?php /* Start the Loop */  ?>
                <?php while ( have_posts() ) : the_post(); ?>
                <?php
                    /* Include the Post-Format-specific template for the content.
                     * If you want to override this in a child theme, then include a file
                     * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                     */
                    get_template_part( 'template-parts/content', get_post_format() );	
                ?>
                <?php endwhile; ?>
                <?php physioplus_pagination(); ?>
                <?php else : ?>
                <?php get_template_part( 'template-parts/content', 'none' ); ?>
                <?php endif; ?>             
			</div>
		</div>
            <!-- /.content left -->
            <?php if ( is_active_sidebar( 'sidebar-1' ) ) { ?>
            <div class="col-md-4 sidebar"><!--sidebar-->
                    <?php dynamic_sidebar( 'sidebar-1' ); ?>
            </div>
            <?php } ?>
            <!-- /.sidebar-->
          </div>
    </div>
</div><!-- /.main-container -->
<?php
get_footer();
?>