<?php
	/*-----------------------------------------------------------*
	/* 			DEFAULT THEME OPTIONS
	/*-----------------------------------------------------------*/
	add_action( 'after_setup_theme', 'thegenius_default_options' );
	
	function thegenius_default_options() {
		$options = array(
			'logo'     					=> get_template_directory_uri().'/images/logo.png',
			'favicon'  					=> get_template_directory_uri().'/images/favicon.ico',
			'topbar_content1'			=> '<div class="row"><div class="col-md-4"><p class="welcome-msg">welcome to physiotharipst center</p>   </div><div class="col-md-5"><p class="navbar-address">7320 Ricckvan Road, Chicago, M03 42JR, st. Zavburg, VB 5421.</p></div><div class="col-md-3 navbar-link-2"><ul><li><a href="#"><i class="fa fa-facebook"></i></a></li><li><a href="#"><i class="fa fa-twitter"></i></a></li><li><a href="#"><i class="fa fa-google-plus"></i></a></li><li><a href="#"><i class="fa fa-pinterest-p"></i></a></li></ul></div></div>',
			
			'topbar_content2'			=> '<div class="row"><div class="col-md-6"><p class="welcome-msg">welcome to physiotharipst center</p>
      </div><div class="col-md-6 navbar-link"><ul><li><a href="#">Location</a></li><li><a href="#">New patient</a></li><li><a href="#">800-123-4567</a></li><li><a class="dark-active" role="button" data-toggle="collapse" href="#collapseExample" aria-expanded="false" aria-controls="collapseExample"> <i class="fa fa-search"></i> </a></li></ul></div></div>',
			
			'logo_right_content' 		=> '<span class="call-number"><i class="fa fa-plus-circle"></i><a class="btn-link" href="#">Book An Appointment</a></span><span class="call-number"><i class="fa fa-phone"></i>800-123-4567 </span><a class="btn btn-default hvr-sweep-to-right" href="#">View Locations</a>',
			
			'general_check_appnt_btn' 	=> 'generalcheckappntbtn',
			'general_appnt_btn_text' 	=> esc_html__('Make An Appointment','physioplus'),			
			'general_appnt_btn_url'  	=> '#',	
			'branches_center_point_lat'	=> '23.040883',	
			'branches_center_point_lng'	=> '72.5567025',
			'google_map_key'			=> '',														
			'background_color'  		=> '#ffffff',
			'accent_color' 				=> '#568aed',
			'accent_hover_color' 		=> '#ff9805',				
			'heading_google_font'		=> 'Adamina:400,400italic,500,500italic,700,700italic,300,300italic',
			'google_font'				=> 'Roboto:400,400italic,500,500italic,700,700italic,300,300italic',			
			'custome_css' 				=> '',
			'font-size-h1'  			=> '28',
			'font-weight-h1' 			=> '400',
			'font-color-h1' 			=> '#363636',
			'font-size-h2'  			=> '22',
			'font-weight-h2' 			=> '400',
			'font-color-h2' 			=> '#363636',
			'font-size-h3'  			=> '20',
			'font-weight-h3' 			=> '400',
			'font-color-h3' 			=> '#363636',
			'font-size-h4'  			=> '18',
			'font-weight-h4' 			=> '400',
			'font-color-h4' 			=> '#363636',			
			'font-size-p'  				=> '16',
			'font-weight-p' 			=> '400',	
			'font-color-p' 				=> '#8e8e8e',
			'topbar_bk_color'  			=> '#ffffff',
			'header_bk_color'	  		=> '#ffffff',
			'menu_bk_color'   			=> '#568aed',
			'menu_text_color'			=> '#dde9ff',
			'menu_bg_hover_color'		=> '#4179e2',					
			'menu_text_hover_color'		=> '#ffffff',
			'menu_sub_bg_color'			=> '#4179e2',
			'menu_sub_hover_bg_color'	=> '#568aed',				
			'breadcrumb_bk_color'		=> '#f6fbff',
			'breadcrumb_bk_image'		=> get_template_directory_uri().'/images/page-header.jpg',				
			'footer_bk_color'			=> '#1f2530',
			'footer_heading_color'		=> '#ffffff',	
			'footer_accent_color'       => '#7e838e',			
			'footer_accent_hover_color' => '#ff9805',			
			'footer_text_color'			=> '#7e838e',
			'currency_symbols'			=> '&#36;',
			'animatespeed'				=> '500',
			'control_nav'				=> 'controlnav',
			'directive_nav'				=> 'directionnav',
			'slider_title_color'        => '#f5f5f5',
			'slider_text_color'         => '#f2f2f2',			
			'slider_arrow_bkcolor'      => '#568aed',
			'slider_arrow_bkcolor_hover'=> '#ff9805', 
			'slider_pagination'			=> '#568aed',
			'slider_pagination_hover'	=> '#ff9805',	
			'slider_effect'				=> 'slide',			 						
			'copyright'					=> esc_html__('Copyright &copy; 2019.All Rights Reserved.','physioplus'),
			'social_facebook'			=> '#',
			'social_twitter'			=> '#',
			'social_google_plus'		=> '#',
			'social_linkedin'			=> '#',
			'header_option'				=> 'first',
	    );
	    return $options;				
	}

	/*-----------------------------------------------------------*
	/* 			THEME OPTION PAGE
	/*-----------------------------------------------------------*/

	add_action( 'admin_init', 'thegenius_add_options' );
	function thegenius_add_options() {
		// Register new options
		register_setting( 'thegenius_options', 'thegenius_options', 'thegenius_options_validate' );
	}

	/*-----------------------------------------------------------*
	/* 			THEME OPTION ADMIN IN MENU
	/*-----------------------------------------------------------*/

	add_action( 'admin_menu', 'thegenius_add_page' );
	function thegenius_add_page() {
		$thegenius_options_page = add_theme_page( 'Theme Options', 'Theme Options', 'manage_options', 'options_page', 'thegenius_options_page' );
		add_action( 'admin_print_scripts-' . $thegenius_options_page, 'thegenius_print_scripts' );
	}
	
	function thegenius_get_option($key)
	{
		$arr=get_option( 'thegenius_options' );
		if( isset( $arr[$key])) {
			return $arr[$key];
		}
	}
	
	function thegenius_print_scripts() {
		wp_enqueue_style('thickbox'); // Stylesheet used by Thickbox
		wp_enqueue_script('thickbox');
		wp_enqueue_script('media-upload');
		wp_enqueue_script('thegenius-thege-upload', get_template_directory_uri().'/framework/js/thege-upload.js', array( 'thickbox', 'media-upload' ) );
		wp_enqueue_script('bootstrap', get_template_directory_uri().'/framework/js/bootstrap.js');	
		wp_enqueue_script('thegenius-script', get_template_directory_uri().'/framework/js/script.js');
		wp_enqueue_style('bootstrap', get_template_directory_uri().'/framework/css/bootstrap.css');
		wp_enqueue_style('bootstrap.vertical-tabs', get_template_directory_uri().'/framework/css/bootstrap.vertical-tabs.css');		
	}	
	add_action( 'admin_enqueue_scripts', 'thegenius_enqueue_color_picker' );
	
	function thegenius_enqueue_color_picker( ) {
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_script( 'thegenius-custom-js', get_template_directory_uri().'/framework/js/custom.js', array('wp-color-picker'),true);
	}


	function thegenius_enqueue_styles_inline_css() {
		
		 $style = '';	
		/*  background color  */
		 $background_color =  thegenius_get_option('background_color');

		 $accent_color = thegenius_get_option('accent_color');
		 $accent_hover_color = thegenius_get_option('accent_hover_color');
		 
		 $custome_css = thegenius_get_option('custome_css');

		 /*  header_background_color  */
		 $top_bk = thegenius_get_option('topbar_bk_color');		 
		 $header_bk = thegenius_get_option('header_bk_color');
		 $menu_bk = thegenius_get_option('menu_bk_color');

		 $breadcrumb_bk_color = thegenius_get_option('breadcrumb_bk_color');

		 $menu_text = thegenius_get_option('menu_text_color');
		 $menu_text_hover = thegenius_get_option('menu_text_hover_color');
		 
 		 $menu_sub_bg_color = thegenius_get_option('menu_sub_bg_color');
 		 $menu_bg_hover_color = thegenius_get_option('menu_bg_hover_color');	
 		 $menu_sub_hover_bg_color = thegenius_get_option('menu_sub_hover_bg_color');			 	 		 		 

		 $footer_bk = thegenius_get_option('footer_bk_color');	
		 $footer_heading_color = thegenius_get_option('footer_heading_color');	
		 $footer_text = thegenius_get_option('footer_text_color');	
		 $footer_accent = thegenius_get_option('footer_accent_color');			 
		 $footer_accent_hover_color = thegenius_get_option('footer_accent_hover_color');

 
		 //Slider Option		 
		 $slider_text_color =  thegenius_get_option('slider_text_color');
		 $slider_title_color =  thegenius_get_option('slider_title_color');

		 $slider_arrow_bkcolor =  thegenius_get_option('slider_arrow_bkcolor');
		 $slider_arrow_bkcolor_hover =  thegenius_get_option('slider_arrow_bkcolor_hover');	
		 
 		 $slider_pagination =  thegenius_get_option('slider_pagination');
 		 $slider_pagination_hover =  thegenius_get_option('slider_pagination_hover');
		 
 		 $slider_effect =  thegenius_get_option('slider_effect');		 		 

		 $control_nav =  thegenius_get_option('control_nav');

		 /* google font [ font-family ] */
		 $google_font = thegenius_get_option('google_font');		 
		 $google_font_family = "";
		 $google_font_family = isset($google_font)?$google_font:'';
	
		 $heading_google_font = thegenius_get_option('heading_google_font');		 
		 $heading_google_font_family = isset($heading_google_font)?$heading_google_font:'';		 

		 if( $google_font_family != '') {
			 wp_enqueue_style( 'heading_google_fonts', 'http'. (is_ssl() ? 's' : '').'://fonts.googleapis.com/css?family='.$google_font_family.'', false );
			
		 }else {
			 wp_enqueue_style( 'heading_google_fonts', 'http'. (is_ssl() ? 's' : '').'://fonts.googleapis.com/css?family=Adamina:400,400italic,700,700italic', false );
		 }
		 

		$google_font_explode = '';
		$font_family_google = explode( ':', $google_font_family );
		$google_font_explode = isset($font_family_google)?$font_family_google:'';

		$font_family = isset($google_font_explode[0])?$google_font_explode[0]:'';
		$font_weight = isset($google_font_explode[1])?$google_font_explode[1]:'';
		
		$font_family = str_replace("+"," ",strtolower($font_family));
	
		$heading_font_family_google = explode( ':', $heading_google_font_family );
		$heading_google_font_explode = isset($heading_font_family_google)?$heading_font_family_google:'';

		$heading_font_family = isset($heading_google_font_explode[0])?$heading_google_font_explode[0]:'';
		$heading_font_weight = isset($heading_google_font_explode[1])?$heading_google_font_explode[1]:'';
		
		
		$font_family = str_replace("+"," ",strtolower($font_family));		

		 if( $google_font_family != '') {
 			 wp_enqueue_style( 'body_google_fonts', 'http'. (is_ssl() ? 's' : '').'://fonts.googleapis.com/css?family='.$heading_google_font_family.'', false );
		 }else {
 			 wp_enqueue_style( 'body_google_fonts', 'http'. (is_ssl() ? 's' : '').'://fonts.googleapis.com/css?family=Adamina:400,700', false );
		 }	

		wp_enqueue_style('tg-custom-style',get_template_directory_uri() . '/framework/css/custom_style.css');			


		$style .= 'html body { background-color: '.$background_color.'; font-family: '.$font_family.' !important; font-weight : '.$font_weight.';  } ' . "\n";
		

		 /*   font h1,h2,h3,h4 typogrphy  */
		if(!empty($heading_google_font_family) ||  !empty(thegenius_get_option('font-size-h1')))
		{
		$style .= 'h1 { font-size 	: '.thegenius_get_option('font-size-h1').'px;
					 font-weight	: '.thegenius_get_option('font-weight-h1').';
					 font-family	: '.$heading_font_family.';
					 color			: '.thegenius_get_option('font-color-h1').';
				} ';
		}

		if(!empty($heading_google_font_family) ||  !empty(thegenius_get_option('font-size-h2')))
		{
		$style .= 'h2 { font-size 	: '.thegenius_get_option('font-size-h2').'px;
					 font-family	: '.$heading_font_family.';		 
					 font-weight	: '.thegenius_get_option('font-weight-h2').';
					 color			: '.thegenius_get_option('font-color-h2').';		
				} ';
		}

		if(!empty($heading_google_font_family) ||  !empty(thegenius_get_option('font-size-h3')))
		{
		
		$style .= 'h3 { font-size 	: '.thegenius_get_option('font-size-h3').'px;
					 font-family	: '.$heading_font_family.';		 
					 font-weight	: '.thegenius_get_option('font-weight-h3').';
					 color			: '.thegenius_get_option('font-color-h3').';
				} ';		
		}
		
		if(!empty($heading_google_font_family) ||  !empty(thegenius_get_option('font-size-h4')))
		{		
		$style .= 'h4 { font-size 	: '.thegenius_get_option('font-size-h4').'px;
				 font-family	: '.$heading_font_family.';		 
				 font-weight	: '.thegenius_get_option('font-weight-h4').';
				 color			: '.thegenius_get_option('font-color-h4').';
			} ';
		}
		
		if(!empty($font_family) ||  !empty(thegenius_get_option('font-size-p')))
		{		
		$style .= 'p { font-size 	: '.thegenius_get_option('font-size-p').'px;
					 font-family	: '.$font_family.';		 
					 font-weight	: '.thegenius_get_option('font-weight-p').';
					 color			: '.thegenius_get_option('font-color-p').';
				} ';
		}

		if(!empty($accent_color))
		$style .= 'a { color:'.$accent_color.'; text-decoration: none; } ';

		if(!empty($accent_hover_color))
		$style .= 'a:hover { color:'.$accent_hover_color.';   text-decoration: none; } ';		 
		
		if(!empty($header_bk))
		$style .= '.header,.header-2 .navbar-default { background-color:'.$header_bk.';  }';

		if(!empty($top_bk))
		$style .= '.top-bar { background-color:'.$top_bk.';  } ';

		
		if(!empty($menu_bk))
		{
			$style .= '.navigation-2 .navbar-default { background-color:'.$menu_bk.';  } ';
			$style .= '.navbar-top-2{ border-top:3px solid '.$menu_bk.';  } ' ;
			$style .= '.is-sticky .navigation{ border-bottom:2px solid '.$menu_bk.'; } ';
		}

		if(!empty($menu_text))
		{
			$style .= '#cssmenu ul li a,#cssmenu.small-screen #menu-button{color:'.$menu_text.'; } ';	 
			
			$style .= '#cssmenu.small-screen #menu-button::before,#cssmenu.small-screen #menu-button.menu-opened::before,#cssmenu.small-screen #menu-button.menu-opened::after{background:'.$menu_text.'; } ';

			$style .='#cssmenu.small-screen #menu-button::after{border-bottom:2px solid '.$menu_text.'; border-top:2px solid '.$menu_text.';} ';	
		}
		
		if(!empty($menu_text_hover) && !empty($menu_bg_hover_color) && !empty($menu_text))
		{
			$style .= '#cssmenu > ul > li:hover > a { color:'.$menu_text_hover.'; background-color:'.$menu_bg_hover_color.'; } ';	 		
	
			$style .= '#cssmenu ul ul li a,#cssmenu.small-screen ul ul li a,#cssmenu ul.dropdown-menu{ background-color:'.$menu_sub_bg_color.';color:'.$menu_text.';} ';
		}
		
		if(!empty($menu_sub_hover_bg_color) && !empty($menu_text_hover))
		{		
			$style .= '#cssmenu ul ul li:hover a,#cssmenu.small-screen ul ul li:hover a{ background-color:'.$menu_sub_hover_bg_color.';color:'.$menu_text_hover.';} ';
		}
		
		if(!empty($breadcrumb_bk_color))
		{
			$style .= '.page-header{ background-color:'.$breadcrumb_bk_color.';  } ';		
		}
		$breadcrumb_bk_image = thegenius_get_option('breadcrumb_bk_image');
		
		if( !empty($breadcrumb_bk_image)) {
			$style .= '.page-header{ background-image:url("'. esc_url( $breadcrumb_bk_image ) .'");} ';		 
		} 	

		if( !empty($footer_bk ))
		$style .= '.footer { background-color:'.$footer_bk.';  } ' ;
		
		if( !empty($footer_heading_color ))
		$style .= '.footer-block h3 { color:'.$footer_heading_color.';  } ' ;
		
		if( !empty($footer_text ))
		$style .= '.footer p,.copyright { color:'.$footer_text.';  } ';
		
		if( !empty($footer_accent ))
		$style .= '.location ul li a { color:'.$footer_accent.';  } ';	
		
		if( !empty($footer_accent ))
		$style .= '.soical-block ul li a { border:2px solid '.$footer_accent.';color:'.$footer_accent.';  } ';	

		if( !empty($footer_accent_hover_color )){
		$style .= '.soical-block ul li a:hover { border:2px solid '.$footer_accent_hover_color.'; color:'.$footer_accent_hover_color.';  } ';	
		}
		
		if( !empty($control_nav )) {
			$style .= '#slider .owl-pagination{ display:none;} ';		 
		} 					

		if( !empty($slider_title_color ))
		$style .= '#slider .slider-caption h1{ color:'.$slider_title_color.';  } ';

		if( !empty($slider_text_color ))
		$style .= '#slider .slider-caption p{ color:'.$slider_text_color.';  } ';		

		if( !empty($slider_arrow_bkcolor ))		
		$style .= 'body #slider .owl-buttons .owl-prev, #slider .owl-buttons .owl-next { background-color:'.$slider_arrow_bkcolor.';} ';
		
		if( !empty($slider_pagination ))				
		$style .= '.owl-theme .owl-controls .owl-page span{ background:'.$slider_pagination.';} ';

		if( !empty($slider_arrow_bkcolor_hover ))		
		$style .= '#slider .owl-buttons .owl-prev:hover, #slider .owl-buttons .owl-next:hover { background-color:'.$slider_arrow_bkcolor_hover.';} ';		

		if( !empty($slider_pagination_hover ))			
		$style .= '.owl-theme .owl-controls .owl-page.active span, .owl-theme .owl-controls.clickable .owl-page:hover span { background-color:'.$slider_pagination_hover.'; } ';
		
	    wp_add_inline_style( 'tg-custom-style', $style );
		
	}

	add_action( 'wp_enqueue_scripts', 'thegenius_enqueue_styles_inline_css' );

	function thegenius_enqueue_inline_script( $handle, $js, $deps = array(), $in_footer = false ){
		// Callback for printing inline script.
		$cb = function()use( $handle, $js ){
			// Ensure script is only included once.
			if( wp_script_is( $handle, 'done' ) )
				return;
	
		   // Print script & mark it as included.
			$speed =  thegenius_get_option('animatespeed');
			$control_nav =  thegenius_get_option('control_nav');
			$directive_nav =  thegenius_get_option('directive_nav');
			$slider_effect =  thegenius_get_option('slider_effect');			
	
			if( $control_nav != '' ) {
				$control_nav_check = 'true';
			}else {
				$control_nav_check = 'false';
			}
	
			if( $directive_nav != '' ) {
				$directive_nav_check = 'true';
			}else {
				$directive_nav_check = 'false';
			}
			
			if($slider_effect!="slide")
			{
				$slider_effect_call= "transitionStyle : '".$slider_effect."'";
			}
			else{
				$slider_effect_call= "";
			}		
	
			echo "<script type=\"text/javascript\">
					var $ = jQuery.noConflict();
					if($('.owl-theme').hasClass('main-slider'))
					{
						$(document).ready(function() {
						  $('.main-slider').owlCarousel({
							  navigation : ".$directive_nav_check.", 
							  slideSpeed : '".esc_js($speed)."',
							  paginationSpeed : '".esc_js($speed)."',
							  singleItem: true,
							  autoHeight : true,
							  navigationText : ['<i class=\"fa fa-angle-left\"></i>','<i class=\"fa fa-angle-right\"></i>'],
							  autoPlay:7000,
        					  addClassActive: true,
								afterMove: previousslide,
								beforeMove: nextslide,					  
							  $slider_effect_call	
							  });
						});

						// First Slide
						$('.owl-item.active .slider-caption').addClass('animated fadeInLeft');
						 
						// Other Slides
						function previousslide() {
							$('.owl-item.active .slider-caption').addClass('animated fadeInLeft');
						}
						function nextslide() {
							 $('.owl-item .slider-caption').removeClass('animated fadeInLeft');
						}							
					}				
				  </script>\n";
				  
			global $wp_scripts;
			$wp_scripts->done[] = $handle;
		};
		// (`wp_print_scripts` is called in header and footer, but $cb has re-inclusion protection.)
		$hook = $in_footer ? 'wp_print_footer_scripts' : 'wp_print_scripts';
	
		// If no dependencies, simply hook into header or footer.
		if( empty($deps)){
			add_action( $hook, $cb );
			return;
		}
	
		// Delay printing script until all dependencies have been included.
		$cb_maybe = function()use( $deps, $in_footer, $cb, &$cb_maybe ){
			foreach( $deps as &$dep ){
				if( !wp_script_is( $dep, 'done' ) ){
					// Dependencies not included in head, try again in footer.
					if( ! $in_footer ){
						add_action( 'wp_print_footer_scripts', $cb_maybe, 11 );
					}
					else{
						// Dependencies were not included in `wp_head` or `wp_footer`.
					}
					return;
				}
			}
			call_user_func( $cb );
		};
		add_action( $hook, $cb_maybe, 0 );
	}

	// Usage
	thegenius_enqueue_inline_script('slider','',array( 'jquery'));	

	/*-----------------------------------------------------------*
	/* 			THEME OPTION PAGE
	/*-----------------------------------------------------------*/
	
	function thegenius_options_page() {
	global $thege_options;
	?>
	<div class='wrap'>
	  <div class="container-fluid">
	   <?php settings_errors( 'thege_framework' ); ?>
	    <div class="page-header">
	      <h1>Theme Options</h1>
	    </div>
	    <div class="row to-wrapper">
	      <div id="to-wrapper">
	        <div class="col-md-2 sidebar">
	          <!-- required for floating -->
	          <!-- Nav tabs -->
	          <ul class="nav nav-tabs tabs-left">
			  	<?php  echo thegenius_theme_tab_menu();?>
	          </ul>
	        </div>
	        <div class="col-md-10">
	          <div class="to-content">
	            <!-- Tab panes --> 
	            <form action='options.php' method='post' class="form-horizontal"> 
	              <?php settings_fields( 'thegenius_options' ); ?>
	              <?php do_settings_sections( 'options_page' ); ?>
	              <div class="tab-content">
	                <?php  echo thegenius_theme_tab_page();   ?>
	              </div>
	              <!-- tab-content -->
	              <p class="submit">
	                <input name="thegenius_options[submit]" type="submit" class="button-primary" value="<?php esc_attr_e('Save Settings', 'physioplus'); ?>" />
	                <input name="thegenius_options[reset]"  type="submit" class="button-secondary" value="<?php esc_attr_e('Reset Defaults', 'physioplus'); ?>" onclick="return confirm('Are you sure to reset default theme setting?')" />
	              </p>
	            </form>
	          </div>
	        </div>
	      </div>
	    </div>
	  </div>
	</div>
<?php  
} 

add_action( 'after_switch_theme', 'thegenius_default_setting_option' );

function thegenius_default_setting_option() {
	$default_check=get_option( 'thegenius_options' );
	if($default_check)
	{
		$thege_default = thegenius_default_options();
		update_option( 'thegenius_options', $thege_default); 
	}
}
?>