<?php
/**
 *  Template Name: Page+Slider
 *
 * @package physioplus
 */

get_header();

?>
<div class="boxed">
<div class="slider" autoplay="on" speed="5000" animate="moveLeft" arrows="on" buttons="off" start-slide="0" hover-pause="on">
    <ul class="slides">
		<li>
			<div>
				<p><img decoding="async" src="/wp-content/uploads/2016/06/vcpt-golfer-performance.jpg" alt="" /></p>
				<p class="txtwrpr bottom-left"><span class="fs-40">Discover Venice Concierge PT (VCPT)</span>
					<span class="fs-22">At VCPT, I bring the clinic to you-delivering expert, one-on-one care in the comfort of your home, fitness club, or even on the golf course. I bring the equipment, expertise, and focused care needed to provide full-body evaluations and personalized treatment. As a Titleist Performance Institute Certified Physical Therapist, I'll help you recover faster, move better, and get back to doing what you love.</span>
					<span class="fs-20 text-left"><a href="/about-us/" class="hvr-sweep-to-right">Know More</a></span>
				</p>
			</div>
		</li>
		<li>
			<div>
				<p><img decoding="async" src="/wp-content/uploads/2016/06/venice-concierge-physical-therapy-focuses-on.png" alt="" /></p>
				<p class="txtwrpr bottom-left"><span class="fs-40">VCPT: ADVANCED MANUAL THERAPY for Pain & Improved Mobility</span>
					<span class="fs-22">VCPT & PT for Golfers Includes Advanced Hands-on Treatments like Myofascial Release, ART, Trigger Point Therapy, Graston Technique, Mobilizations, Osteopathic techniques & more to improve mobility and for faster pain relief!</span>
					<span class="fs-20 text-left"><a href="/about-us/#advanced-manual-therapy" class="hvr-sweep-to-right">Know More</a></span>
				</p>
			</div>
		</li>
		<li>
			<div>
				<p><img decoding="async" src="/wp-content/uploads/2016/06/vcpt-happy-couple-biking.jpg" alt="" /></p>
				<p class="txtwrpr bottom-left"><span class="fs-40">Do What You Love Again!</span>
					<span class="fs-22">Let VCPT get you back safely to GOLF, WALKING, BIKING, PICKLEBALL, SHOPPING, TENNIS, The BEACH, PLAYING with your GRANDCHILDREN or just managing your home. Recovering from injury, surgery or just stiffness/weakness - you CAN reclaim your freedom and joy today!</span>
					<span class="fs-20 text-left"><a href="/about-us/#individualized-home-exercise-program" class="hvr-sweep-to-right">Know More</a></span>
				</p>
			</div>
		</li>
		<li>
			<div>
				<p><img decoding="async" src="/wp-content/uploads/2023/03/vcpt-for-golfers.jpg" alt="" /></p>
				<p class="txtwrpr bottom-left">
					<span class="fs-40">Kimberly DelVecchio, PT for GOLFERS</span>
					<span class="fs-22">TPI CERTIFIED & NG360 - Nike Golf functional performance trainer, powered by Gray Institute; Kimberly DelVecchio is passionate about working with individuals dedicated to getting better. And Golfers are passionate about golf and are willing to do what needs to be done to play better. Together, we can get you playing BETTER and without pain!</span>
					<span class="fs-20 text-left"><a href="/therapist/" class="hvr-sweep-to-right">Know More</a></span>
				</p>
			</div>
		</li>
	</ul><p class="arrows"><span id="prev" title="Previous"><</span> <span id="next" title="Next">></span></p><p class="buttons"></p>
</div>
</div>

<?php

/*$args = array( 'post_type' => 'slider' , 'posts_per_page' => -1 , 'orderby' => 'menu_order ID','order' => 'ASC','post_status'=> 'publish' );
$loop = new WP_Query( $args );

if($loop->have_posts())
{
?>
<div class="slider"><!-- slider start -->
  <div id="slider" class="owl-carousel owl-theme main-slider">
	<?php while ( $loop->have_posts() ) : $loop->the_post();  ?>
    <div class="item">
		<?php 
		  if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
			  the_post_thumbnail( 'full');
		  }
        ?>    
        <div class="container">
          <div class="col-md-6 slider-caption">
                <h1 class="slider-title"><?php the_title(); ?></h1>
                <p class="slider-description"><?php echo get_post_meta( $post->ID, 'slider_content', true); ?></p>
                <?php if(get_post_meta( $post->ID, 'slider_btn_onoff', true )=='on'){ ?>
                <a href="<?php echo esc_url(get_post_meta( $post->ID, 'slider_btn_url', true ));?>" class="btn btn-default hvr-sweep-to-right">
                <?php echo get_post_meta( $post->ID, 'slider_btn_txt', true ); ?></a>
                <?php } ?>
            </div>
        </div>
    </div><!-- /.item  -->
	<?php 
    endwhile;
    wp_reset_postdata();
    ?>
  </div>
</div>
<!-- /.slider end -->

<?php 
} */

while ( have_posts() ) : the_post(); 
?>
<div class="page-slider-content">
    <?php the_content(); ?>
</div>
<?php
endwhile; // End of the loop. ?>
<?php get_footer(); ?>