<?php
define("SITE_URL", get_permalink(157));
/*added sidebar for Your Conditions or Pain pages*/
function physioplus_rs() {
	register_sidebar( array(
		'name'          => esc_html__( 'Your Conditions/Pain Single', 'physioplus' ),
		'id'            => 'sidebar-ycp',
		'description'   => esc_html__( 'Add widgets here.', 'physioplus' ),
		'before_widget' => '<div id="%1$s" class="%2$s widget">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2>',
		'after_title'   => '</h2>',
	) ); 
}
add_action( 'widgets_init', 'physioplus_rs' );


//child pages
function ycp_child_pages($atts) {

$atts = shortcode_atts( array("parent"=>"","number"=>"", "more"=>""), $atts, "ycp" );

if($atts['parent']==""){return "";}

if($atts['more']=="on"){
$view_more = '<p class="center"><a href="/your-conditions-pain/" class="btn btn-default hvr-sweep-to-right">View More</a></p>';
}

    $args = array (
        'parent' => $atts['parent'],
        'number' => $atts['number'],
        'sort_column' => 'menu_order',
        'sort_order' => 'asc'
    );
    $pages = get_pages($args);

foreach( $pages as $page ) {
    
    $title = $page->post_title;
    $thumbnail = get_the_post_thumbnail($page->ID, 'post-thumbnail', array( 'class' => 'img-responsive wp-post-image', 'decoding'=>'async', 'loading'=>'lazy' ));
    $permalink = get_page_link( $page->ID );
    $excerpt = get_the_excerpt($page->ID);
    
    
    $ycp_item[] = '<div class="owl-item"><div class="col-md-4 service-thumbnail item"><div class="service-img zoom-pic"><a href="'. $permalink .'">'. $thumbnail .'</a></div>';
    $ycp_item[] .= '<div class="service-content"><h2>'. $title .'</h2>' . '<p>'. $excerpt .'</p></div></div></div>';
}

$ycp_item = implode( ' ', $ycp_item );
return '<div id="service-thumbnail"><div class="owl-wrapper-outer"><div class="owl-wrapper">' . $ycp_item . '</div></div>'.$view_more.'</div>';

}

//get the post title
function get_post_title($atts){
	$atts = shortcode_atts(
		array(
			'title' => '',
		), $atts, 'post-head' );
		
		if($atts["title"]===""){
		    return "<h1><strong>".get_the_title()."</strong></h1>";
		}
		else{
		   return "<h1><strong>".$atts["title"]."</strong></h1>";  
		}

}

//get Video HTML5
function getVideo($atts){

	$atts = shortcode_atts(array('src'=>'', 'width'=>'', 'height'=>'', 'play'=>'off', 'id'=>'', 'class'=>'vid','style'=>'background: #f0f0f0;'), $atts, 'vid');
	
	
	$style = ' style="'.$atts['style'].'"';
	$src = ' src="' . $atts['src'] . '"';
	$id = ' id="' . $atts['id'] . '"';
	$class = $atts['class'];
	$play = ' play="'.$atts['play']. '"';
	$width = $atts['width'];
	$height = $atts['height'];
	
	if($class!=""){
	    $class = ' class="'.$class.'"';
	}
	
	return '<p'.$id.$class.$src.$play.$width.$height.$style.' muted><img src="'.SITE_URL.'img/yt-play-btn.png" alt="Play Video" title="Play Video"/></p>';

		
}

//get YT
function getYT($atts){

	$atts = shortcode_atts(
	 array('id'=>'', 'res'=>'maxres', 'play'=>'off'), $atts, 'yt'
	);
	
	$play = ' play="'.$atts['play']. '"';
	
	return '<p class="yt" id="'.$atts['id'].'" res="'.$atts['res'].'" '.$play.' title="Play Video" style="height: 150px;"><span>Loading Video...</span><img src="'.SITE_URL.'img/yt-play-btn.png" class="play" alt="Play Video" title="Play Video"/></p>';

		
}

add_shortcode( 'yt', 'getYT' );

add_shortcode( 'vid', 'getVideo' );

add_shortcode( 'post-head', 'get_post_title' );

add_shortcode( 'ycp', 'ycp_child_pages' );
	
add_post_type_support( 'page', 'excerpt' );

/*Contact Form 7 Spam Filter*/
add_filter( 'wpcf7_spam', function( $spam ) {
	
	$sk_arr = array("joannariggs30@gmail.com", "monkeydigital", "ebojajuje04@gmail.com", "newling.rosario@yahoo.com", "ericjonesmyemail@gmail.com", "raymondHeaclefeX@gmail.com", "zekisuquc419@gmail.com", "joannariggs02@gmail.com", "info@verret.medicopostura.com");	
	
	if ( $spam ) {return $spam;}
		foreach($sk_arr as $kwd){
			if ( false !== stripos( $_POST['your-email'], $kwd ) ) {
    			$spam = true;
			}
		}	
 
 	return $spam;
	
}, 10, 1 );

?>