<?php
add_action( 'add_meta_boxes', 'thegenius_time_meta_box' );
/* Do something with the data entered */
add_action( 'save_post', 'thegenius_time_meta_save' );
/* Adds a box to the main column on the Post and Page edit screens */

function thegenius_time_meta_box() {
    add_meta_box(
        'time_table',
        esc_html__( 'Time Table', 'physioplus' ),
        'thegenius_time_table_custom_box',
        'branches');
}
/* Prints the box content */
function thegenius_time_table_custom_box() {
    global $post;
    // Use nonce for verification
    wp_nonce_field( plugin_basename( __FILE__ ), 'thegenius_time_table_nonce' );
    ?>
    <div class="time_details">
        <?php	
        //get the saved meta as an arry
        $time = get_post_meta($post->ID,'time',true);
        $c = 0;     

		if(is_array($time)) {      
        foreach( $time as $consult_time ) { 
		
            if ( isset( $consult_time['consult'] )) 
            {                 
                printf( '<p> Consult Day&nbsp;<input type="text" name="time[%1$s][consult]" value="%2$s" />&nbsp;&nbsp; Time <input type="text"  name="time[%1$s][time]" value="%3$s" /> <button class="remove_time remove_career_option_btn">%4$s</button></p>', $c, $consult_time['consult'], $consult_time['time'],        'Remove' );                 
                $c = $c +1;             
                }         
            }     
        }
        echo '<span id="here"></span>';
        ?>   
    </div>	
    <div class="clear_div">
    <button class="add button button-primary button-large"><?php esc_html_e('Add Day Time','physioplus'); ?></button>
    </div>
	<script type="text/javascript">
    var $ =jQuery.noConflict();
    $(document).ready(function() {
        var count = <?php echo esc_js($c); ?>;
        $(".add").click(function() {
            count = count + 1;    
            $('#here').append('<p> Consult Day&nbsp;<input type="text" name="time['+count+'][consult]" value="" />&nbsp;&nbsp; Time: <input type="text" name="time['+count+'][time]" value="" /><button class="remove_time remove_career_option_btn">Remove</button></p>');
            return false;
        });
        $(document).on('click', '.remove_career_option_btn', function () {    
            $(this).parent().remove();
        });
    });
    </script>  
    <style type="text/css">
    #time_table .inside { margin:0; padding:0; }
    #time_table { clear:both; }	
    .time_details { margin-left:25px; }
    .clear_div {   padding: 10px;  clear: both;  border-top: 1px solid #ddd;  background: #f5f5f5;}	
    .remove_time{   background: #b73b27;
      border-color: #7f291b;
      color: #fff;
      text-shadow: none;
      border-radius: 3px;
      border-width: 1px;
      padding:3px 10px;
      float:right;
      margin-right:20px;
    }
    .remove_time:hover {   background: #b73b27;
      border-color: #7f291b;
      color: #fff;
      text-shadow: none;
      border-radius: 3px;
      border-width: 1px;
      padding:3px 10px;
     }	
    .last_price{
        width:100px;
    }
    </style>    
<?php 
}

function thegenius_time_meta_save( $post_id ) {  
    // verify if this is an auto save routine. 
    // If it is our form has not been submitted, so we dont want to do anything
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
        return;
    // verify this came from the our screen and with proper authorization,
    // because save_post can be triggered at other times
    if ( !isset( $_POST['thegenius_time_table_nonce'] ) )
        return;
    if ( !wp_verify_nonce( $_POST['thegenius_time_table_nonce'], plugin_basename( __FILE__ ) ) )
        return;
    // OK, we're authenticated: we need to find and save the data
    $time = $_POST['time'];
    update_post_meta($post_id,'time',$time);
}
?>