<?php 
/********************************************/
/*
/*		Plugin shortcode for p and br tags
/*
/********************************************/

function physioplus_plugin_fix_shortcodes($content){   
    $array = array (
        '<p>[' => '[', 
        ']</p>' => ']', 
        ']<br />' => ']'
    );

    $content = strtr($content, $array);
    return $content;
}
add_filter('the_content', 'physioplus_plugin_fix_shortcodes');

/********************************************/
/*
/*		Row
/*
/********************************************/

add_shortcode( 'row', 'physioplus_plugin_sc_row' );
function physioplus_plugin_sc_row( $atts, $content ){	
	$atts = shortcode_atts( array(
      "class" => false,	  
	), $atts );

	$custom_class  = ( $atts['class'] ) ? ' '.$atts['class'] : '';	

    return sprintf( 
      '<div class="row%s">%s</div>',
      esc_attr($custom_class),
      do_shortcode($content)
    );
}

/********************************************/
/*
/*		Inner Row
/*
/********************************************/

add_shortcode( 'inner-row', 'physioplus_plugin_sc_inner_row' );
function physioplus_plugin_sc_inner_row( $atts, $content ){	
    return sprintf( 
      '<div class="row">%s</div>',
      do_shortcode($content)
    );
}
/********************************************/
/*
/*		Container
/*
/********************************************/

add_shortcode( 'container', 'physioplus_plugin_sc_container' );
function physioplus_plugin_sc_container( $atts, $content ){	
    return sprintf( 
      '<div class="container">%s</div>',
      do_shortcode($content)
    );
}

/********************************************/
/*
/*		Icon
/*
/********************************************/

add_shortcode( 'icon', 'physioplus_plugin_sc_icon' );
function physioplus_plugin_sc_icon( $atts, $content ){	
    return sprintf( 
      '<div class="%s"><i class="%s" style="color:%s"></i></div>',
       $atts['class'],
       $atts['icon'],
       $atts['color'],      
      do_shortcode( $content )
    );
}


/********************************************/
/*
/*		COLUMN.
/*
/********************************************/

add_shortcode( 'column', 'physioplus_plugin_sc_column' );
function physioplus_plugin_sc_column( $atts, $content ){	
	$atts = shortcode_atts( array(
      "md" => false,
      "class" => false,	  
	), $atts );

	$class  = ( $atts['md'] ) ? $atts['md'] : '';
	$custom_class  = ( $atts['class'] ) ? ' '.$atts['class'] : '';	
	
    return sprintf( 
      '<div class="col-md-%s%s">%s</div>',
       esc_attr($class),
       esc_attr($custom_class),
      do_shortcode( str_replace("<br />", "", force_balance_tags($content)))
    );
}

/********************************************/
/*
/*		INNER COLUMN.
/*
/********************************************/

add_shortcode( 'inner-column', 'physioplus_plugin_sc_inner_column' );
function physioplus_plugin_sc_inner_column( $atts, $content ){	
	$atts = shortcode_atts( array(
      "md" => false,
      "class" => false,	  
	), $atts );

	$class  = ( $atts['md'] ) ? $atts['md'] : '';
	$custom_class  = ( $atts['class'] ) ? ' '.$atts['class'] : '';	
	
    return sprintf( 
      '<div class="col-md-%s%s">%s</div>',
       esc_attr($class),
       esc_attr($custom_class),	   
      do_shortcode( str_replace("<br />", "", force_balance_tags($content)))
    );
}

/********************************************/
/*
/*		UL.
/*
/********************************************/

add_shortcode( 'ul', 'physioplus_plugin_sc_ul' );
function physioplus_plugin_sc_ul( $atts, $content ){	
    return sprintf( 
      '<ul class="%s list-view">%s</ul>',
	  $atts['class'],
      do_shortcode($content )
    );
}

/********************************************/
/*
/*		OL.
/*
/********************************************/

add_shortcode( 'ol', 'physioplus_plugin_sc_ol' );
function physioplus_plugin_sc_ol( $atts, $content ){	
    return sprintf( 
      '<ol class="list-view">%s</ol>',
      do_shortcode( $content )
    );
}

/********************************************/
/*
/*		LI.
/*
/********************************************/

add_shortcode( 'li', 'physioplus_plugin_sc_li' );
function physioplus_plugin_sc_li( $atts, $content ){ 
    return sprintf( 
      '<li>%s</li>',
      do_shortcode( str_replace("<br />", "", force_balance_tags($content)) )
    );
}

/********************************************/
/*
/*		DIVIDER.
/*
/********************************************/

add_shortcode( 'divi', 'physioplus_plugin_sc_divi' );
function physioplus_plugin_sc_divi( $atts, $content ){	
    
	if(!empty($atts['class']))
	{
		$classes=$atts['class'];
	}
	else
	{
		$classes="divi";
	}

    return sprintf( 
      '<div class="%s"> %s </div>',
      $classes,
      do_shortcode( $content )
    );
}

/********************************************/
/*
/*		BUTTON.
/*
/********************************************/

add_shortcode( 'button', 'physioplus_plugin_sc_button' );
function physioplus_plugin_sc_button( $atts, $content ){	
    
	if(!empty($atts['class']))
	{
		$classes=$atts['class'];
	}
	else
	{
		$classes="btn-outline btn-outline-default";
	}
	

	if(!empty($atts['target']))
	{
		$target=$atts['target'];
	}
	else
	{
		$target="_self";
	}	

    return sprintf( 
      '<a href="%s" class="%s" target="%s"> %s </a>',
	  $atts['url'],
      $classes,
      $target,
      do_shortcode( $content )
    );
}

/********************************************/
/*
/*    Iconbox
/*
/********************************************/

add_shortcode( 'iconbox', 'physioplus_plugin_sc_iconbox' );
function physioplus_plugin_sc_iconbox( $atts, $content ){  
    if($atts['layout']=="icon-box-left")
    {
      return sprintf( 
        '<div class="feature-box mtop2"><div class="feature-icon mbtm3"><i class="fa-2x %s"></i></div><div class="feature-info"><h2 class="feature-title">%s</h2><p>%s</p></div></div>',
         $atts['icon'],
         $atts['title'],      
        do_shortcode( $content )
      );
    }
    else if($atts['layout']=="icon-box-center")
    {
      return sprintf( 
        '<div class="feature-block mtop2 text-center"><div class="text-center  mbtm3"><i class="fa-2x  %s"></i></div><h2 class="item-title">%s</h2><p>%s</p></div>',
         $atts['icon'],
         $atts['title'],      
        do_shortcode( $content )
      );
    }    
    else if($atts['layout']=="icon-box-right")
    {
      return sprintf( 
        '<div class="feature-block mtop2 text-right"><div class="text-right mbtm3"><i class="fa-2x %s"></i></div><h2 class="item-title">%s</h2><p>%s</p></div>',
         $atts['icon'],
         $atts['title'],      
        do_shortcode( $content )
      );
    }    
    else if($atts['layout']=="icon-center-border")
    {
      return sprintf( 
        '<div class="feature-block-outline">
          <div class="flat-icon flat-icon-xs"> <i class="%s"></i></div>
          <h2>%s</h2>
          <p>%s</p>
        </div>',
         $atts['icon'],
         $atts['title'],      
        do_shortcode( $content )
      );
    }    


}

/********************************************/
/*
/*		Alert
/*
/********************************************/

add_shortcode( 'alert', 'physioplus_plugin_sc_alert' );
function physioplus_plugin_sc_alert( $atts, $content ){	
    
	if(!empty($atts['class']))
	{
		$classes=$atts['class'];
	}
	else
	{
		$classes="alert-standard";
	}

    return sprintf( 
      '<div class="alert %s"> %s </div>',
      $classes,
      do_shortcode( $content )
    );
}

/********************************************/
/*
/*    Section
/*
/********************************************/

add_shortcode( 'section', 'physioplus_plugin_sc_section' );
function physioplus_plugin_sc_section( $atts, $content ){
   extract(shortcode_atts(array(
    'title' => 'Collapse',
    'id'  => false,
    'class' => false,
  ), $atts));
  

  $GLOBALS['section'][] = array( 
    'title'   =>  esc_attr($title) ,
    'id'    =>  esc_attr($id),
    'class'   =>  esc_attr($class) ,
    'content' =>  $content ,
  );

  $id  = "collapse-id-".$GLOBALS['collapsibles_count'];
  
    foreach( $GLOBALS['section'] as $tab ){     
    $class = ( !empty($tab['class']) && $tab['class']=="active" ) ? "panel-collapse collapse in"  : "panel-collapse collapse";    
    $__title = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($tab['title'])  );   
    $return = sprintf( "\n".'    
     <div class="panel panel-default">
      <div class="panel-heading">
          <h4 class="panel-title">    
            <a data-toggle="collapse" data-parent="#%s" href="#%s">%s </a>
          </h4>
      </div>      
      <div id="%s" class="%s">
          <div class="panel-body">             
          %s
          </div>
      </div>      
    </div>'."\n" , 
      $id, $__title, $tab['title'], $__title, $class, $tab['content']
    );    
    } // foreach    

  return do_shortcode($return);
  
}// function ending

/********************************************/
/*
/*    Accordion
/*
/********************************************/

add_shortcode( 'accordion', 'physioplus_plugin_sc_accordion' );
function physioplus_plugin_sc_accordion( $atts, $content ){ 
  
  if(isset( $GLOBALS['collapsibles_count'] )) {
    $GLOBALS['collapsibles_count']++;
  }else {
    $GLOBALS['collapsibles_count'] = 0; 
  }

  $id  = "collapse-id-".$GLOBALS['collapsibles_count'];

  return  do_shortcode(sprintf('<div class="st-accordion check-accordion"><div class="panel-group" id="%s"> %s </div></div> ', esc_attr($id), $content));
}

/********************************************/
/*
/*    Bootstrap Tabs.
/*
/********************************************/

add_shortcode( 'tab', 'physioplus_plugin_sc_tabs' );
function physioplus_plugin_sc_tabs( $atts, $content ){
  extract(shortcode_atts(array(
    'title' => 'Tab',
    'class' => false,
  ), $atts));
    
   $x = isset($GLOBALS['tab_count'])?$GLOBALS['tab_count']:0; 
   $GLOBALS['tab_count'] = isset($GLOBALS['tab_count'])?$GLOBALS['tab_count']:0;      

   $GLOBALS['tabs'][$GLOBALS['tabs_count']][$x] = array( 
      'title'   => esc_attr($title),
      'class'   => esc_attr($class),
      'content'   => $content,
   );
     
   $GLOBALS['tab_count']++;
}

/********************************************/
/*
/*    Tabgroup 
/*
/********************************************/

add_shortcode( 'tabgroup', 'physioplus_plugin_sc_tabgroup' );
function physioplus_plugin_sc_tabgroup( $atts, $content ){
  
    if( isset( $GLOBALS['tabs_count'] ) )
      $GLOBALS['tabs_count']++;
    else
      $GLOBALS['tabs_count'] = 0;

  do_shortcode( $content ); 

  if( is_array( $GLOBALS['tabs'][$GLOBALS['tabs_count']] ) ){
    
    $tabs=array();
    $panes=array();
    
    foreach( $GLOBALS['tabs'][$GLOBALS['tabs_count']] as $tab ){

    $panes_class  = ( !empty($tab["class"]) &&  $tab['class'] == "active" ) ? 'tab-pane active' : 'tab-pane';
    $__title = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($tab['title'])  );   
    $tabs[] = '<li  role="presentation" class="'.$tab['class'].'" >
            <a href="#'.$__title.'" data-toggle="tab">'.$tab['title'].'</a>
          </li>';
    $panes[] = sprintf( '<div class="%s" id="%s"> %s </div>',esc_attr($panes_class),esc_attr($__title), $tab['content']  );
    }

    $return = "\n".'<div role="tabpanel">
              <ul role="tablist" class="nav nav-tabs nav-justified">'
                .implode( "\n", $tabs ).
              '</ul>'."\n".
              '<div class="tab-content product-tab">'
                  .implode( "\n", $panes ).
              '</div>
            </div>'."\n";   
  } 
  return do_shortcode( sprintf('<div class="st-tab"> %s </div>',  str_replace("<br />","",$return)));
}

/********************************************/
/*
/*    FAQs
/*
/********************************************/

add_shortcode( 'question', 'physioplus_plugin_sc_question' );
function physioplus_plugin_sc_question( $atts, $content ){
	extract(shortcode_atts(array(
	'title' => 'Collapse',
	'id'  => false,
	'class' => false,
	), $atts));  

	$GLOBALS['question'][] = array( 
	'title'   =>  esc_attr($title) ,
	'id'    =>  esc_attr($id),
	'content' =>  $content ,
	);
	
	foreach( $GLOBALS['question'] as $faq ){     
	$faq_title = preg_replace('/[^a-zA-Z0-9._\-]/', '', strtolower($faq['title'])  );   
	$return = sprintf( "\n".'    
	  <h3><span class="question-mark">Q.</span>%s?</h3>      
	  <p>%s</p>'."\n" , $faq['title'], str_replace("<br />","",$faq['content'])
	);    
	} // foreach    

  return do_shortcode($return);
  
}// function ending

add_shortcode( 'faq', 'physioplus_plugin_sc_faq' );
function physioplus_plugin_sc_faq( $atts, $content ){ 
  
  if(isset( $GLOBALS['faq_count'] )) {
    $GLOBALS['faq_count']++;
  }else {
    $GLOBALS['faq_count'] = 0; 
  }
  $id  = "faq-boxes-id-".$GLOBALS['faq_count'];

  return  do_shortcode(sprintf('<div class="faq_boxes" id="%s"> %s </div>', esc_attr($id), $content));
}

/********************************************/
/*
/*    OWL IMAGE shortcode.
/*
/********************************************/

add_shortcode( 'owl-img', 'physioplus_plugin_sc_owl_img' );
function physioplus_plugin_sc_owl_img( $atts, $content ){ 
	if(!empty($atts['src']))
	{
		$content='<div class="item"><img src="'.esc_url($atts['src']).'" class="img-responsive" alt=""></div>';
	}
	else
	{
		$content='<div class="item"></div>';
	}

    return sprintf( 
      '%s',
      do_shortcode( $content )
    );
}

/********************************************/
/*
/*    OWL Content shortcode.
/*
/********************************************/

add_shortcode( 'owl-content', 'physioplus_plugin_sc_owl_content' );
function physioplus_plugin_sc_owl_content( $atts, $content ){ 
	return sprintf( 
		'<div class="item facility-info"><h1>%s</h1><p>%s</p></div>',
		 $atts['title'],
		do_shortcode( $content )
	  );
}


/********************************************/
/*
/*		owl-gallery
/*
/********************************************/

add_shortcode( 'owl-gallery', 'physioplus_plugin_sc_owl_gallery' );
function physioplus_plugin_sc_owl_gallery( $atts, $content ){
	
	$atts = shortcode_atts( array(
      "box" => false,	  
	), $atts );
	
	
	if($atts['box']==1)
	{
		$owl_class=" testimonial-slide";
	}
	else{
		$owl_class=" client-logo";		
	}	
		
    return sprintf( 
      '<div class="owl-carousel owl-theme%s"> %s </div>',
	  $owl_class,
      do_shortcode( $content )
    );
}

/********************************************/
/*
/*		tp-space
/*
/********************************************/

add_shortcode( 'tp-space', 'physioplus_plugin_sc_tp_space' );
function physioplus_plugin_sc_tp_space( $atts, $content ){	

	if(isset($atts['class']))
	{
		$classes=' '.$atts['class'];
	}
	else{
		$classes='';
	}

    return sprintf( 
      '<div class="section-space%s"><div class="container">%s</div></div>',
	  $classes,
      do_shortcode( $content )
    );
}


/********************************************/
/*
/*		tp-space
/*
/********************************************/

add_shortcode( 'tp-box', 'physioplus_plugin_sc_tp_box' );
function physioplus_plugin_sc_tp_box( $atts, $content ){	

	if(isset($atts['class']))
	{
		$classes=' '.$atts['class'];
	}
	else{
		$classes='';
	}

    return sprintf( 
      '<div class="section-space%s">%s</div>',
	  $classes,
      do_shortcode( $content )
    );
}

/********************************************/
/*
/*		overlay title
/*
/********************************************/

add_shortcode( 'overlay-title', 'physioplus_plugin_sc_overlay_title' );
function physioplus_plugin_sc_overlay_title( $atts){	

	
	$atts = shortcode_atts( array(
      "title" => false,	 
	  "url" => false,	 
	  "img" => false,	 
      "icon" => false,	 
	), $atts );


	$img_html='<div class="zoom-pic"><a href="'.$atts['url'].'"><img class="img-responsive" alt="" src="'.$atts['img'].'"></a></div>';	

	if($atts['icon'])
	{
		$title= $atts['title']. '<span class="pull-right"><i class="'.$atts['icon'].'"></i></span>';
	}
	else
	{
		$title=$atts['title'];
	}


    return sprintf( 
      '<div class="zoom-pic"><a href="%s"><img class="img-responsive" alt="" src="%s"></a></div><div class="block-caption">
              <h2  class="block-title">%s </h2>
            </div>',
	  $atts['url'],
	  $atts['img'],
	  $title
    );
}

/********************************************/
/*
/*    Careers block
/*
/********************************************/

add_shortcode( 'careers-block', 'physioplus_plugin_sc_careers_block' );
function physioplus_plugin_sc_careers_block()
{

	$args = array( 'post_type' => 'career' , 'posts_per_page' => -1 , 'orderby' => 'menu_order ID','order' => 'ASC','post_status'=> 'publish' );
	$loop = new WP_Query( $args );

	$content= "";
	$total_element=count($loop->posts);

	if($loop->have_posts())			
	{
		while ( $loop->have_posts() ) : $loop->the_post();

		$career_timing_html='';
		$career_branch_html='';
		$postid = get_the_ID();
		$career_timing=get_post_meta( $postid, 'career_timing', true );
		$career_branch=get_post_meta( $postid, 'career_branch', true );				

		if(!empty($career_branch) && $career_branch!=0)
		{
			$career_branch_html = '<span class="job-location"><i class="fa fa-map-marker"></i>'.get_the_title( $career_branch ).'</span>';
		}
		
		if(!empty($career_timing))
		{
			$career_timing_html = '<div class="label label-default mbtm-1">'.$career_timing.'</div>';
		}

		
		$content .= '<li class="list-group-item job-list">
              <h3><a class="job-title" href="'.get_permalink( $postid).'">'.get_the_title( $postid).'</a></h3>
              '.$career_branch_html.' <a class="btn-link pull-right arrow-link" href="'.get_permalink( $postid).'"><i class="flaticon-right139"></i></a> </li>';

		endwhile;
		wp_reset_postdata();		
	}
    return  do_shortcode(sprintf('<div class="current-job-block"><div class="current-job-listing"><ul class="list-group listnone"> %s </ul></div></div>', $content));	
}


/********************************************/
/*
/*    blog-block shorcode.
/*
/********************************************/

add_shortcode( 'blog-block', 'physioplus_plugin_sc_blog_block' );
function physioplus_plugin_sc_blog_block($atts)
{
	$atts = shortcode_atts( array(
      "title" => false,
      "sub-title" => false,	 
      "details" => false,	 	   
	), $atts );

	if(isset($atts['title']))
	{
		$title = isset($atts['title']) ? $atts['title'] : '';
		$sub_title = isset($atts['sub-title']) ? $atts['sub-title'] : '';
		$details = isset($atts['details']) ? $atts['details'] : '';
		
		$title_html='<div class="row">
			  <div class="col-md-5">
				<h1>'.$title.'</h1>
				<h5 class="small-title left">'.$sub_title.'</h5>
			  </div>
			  <div class="col-md-7">
				<p class="lead">'.$details.'</p>
			  </div>
			</div>';
	}
	else{
		$title_html='';
	}

	$args = array( 'post_type' => 'post' , 'posts_per_page' => -1 , 'orderby' => 'menu_order ID','order' => 'DESC','post_status'=> 'publish' );
	$loop = new WP_Query( $args );

	$content= "";
	$i=0;

	if($loop->have_posts())		
	{
		while ( $loop->have_posts() ) : $loop->the_post();
		
		$postid = get_the_ID();
		if(get_the_post_thumbnail($postid))
		{
		
			if($i<3)	
			{
			$byline = sprintf(
				esc_html_x( '%s', 'post author', 'physioplus' ),
				'<span class="meta-author"><i class="fa fa-user"></i>By <a class="meta-link" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
			);
		
			if (( comments_open() || get_comments_number() ) ) {
			$comments= (get_comments_number()==1 || get_comments_number()==0?(esc_html__( ' Comment', 'physioplus' )):( esc_html__( ' Comments', 'physioplus' )));
			$comments_meta='<span class="meta-comment"><i class="fa fa-commenting"></i><a href="'.get_comments_link().'">'.$comments.' ('.get_comments_number().') </a></span>';
			}

	$meta_date = '<span class="meta-bg"> <span class="date">'.get_the_date( 'd', $postid ).'</span> <span>'.get_the_date( 'M', $postid ).'</span> </span>';
	
		
		$content .= '<div class="col-md-4 post-block">
        <div class="post-image zoom-pic"> <a href="'.get_permalink($postid).'">'.get_the_post_thumbnail($postid,'full',array('class'=>'img-responsive')).'</a> </div>
        <div class="post-content">'.$meta_date.'
          <h3><a href="'.get_permalink($postid).'" class="post-title">'.get_the_title($postid).'</a></h3>
          <div class="meta"> <span class="meta-line"></span> '.$comments_meta.' '.$byline.'</div>
          <p>'.get_the_excerpt().'</p>
          <a href="'.get_permalink($postid).'" class="btn btn-default hvr-sweep-to-right">'.__( 'Read More', 'physioplus').'</a> </div>
      </div>';
		
			$i++;
			}
		
		}
		endwhile;
		wp_reset_postdata();		
	}
    return  do_shortcode(sprintf('<div class="section-space"><div class="container">%s<div class="row"> %s </div></div></div>', $title_html, $content));		
}


/********************************************/
/*
/*    branches block shortcode.
/*
/********************************************/

add_shortcode( 'branches-block', 'physioplus_plugin_sc_branches_block' );
function physioplus_plugin_sc_branches_block($atts)
{
	$atts = shortcode_atts( array(
      "title" => false,
      "sub-title" => false,	 
      "details" => false,	 	   
	), $atts );

	if(isset($atts['title']))
	{
		$title = isset($atts['title']) ? $atts['title'] : '';
		$sub_title = isset($atts['sub-title']) ? $atts['sub-title'] : '';
		$details = isset($atts['details']) ? $atts['details'] : '';
		
		$title_html='<div class="row">
			  <div class="col-md-5">
				<h1>'.$title.'</h1>
				<h5 class="small-title left">'.$sub_title.'</h5>
			  </div>
			  <div class="col-md-7">
				<p class="lead">'.$details.'</p>
			  </div>
			</div>';
	}
	else{
		$title_html='';
	}

	$content= '';	
	$google_map_arr='';	
		
	$args = array( 'post_type' => 'branches' , 'posts_per_page' => -1 , 'orderby' => 'menu_order ID','order' => 'ASC','post_status'=> 'publish' );
	$branches = new WP_Query( $args );

	$i=1;
	if($branches->have_posts())		
	{
		while ( $branches->have_posts() ) : $branches->the_post();
		
		$postid = get_the_ID();

        $branches_address = get_post_meta( $postid, 'branches_address', true );
        $branches_email = get_post_meta( $postid, 'branches_email', true );
        $branches_phone = get_post_meta( $postid, 'branches_phone', true );

		$locators = get_post_meta( $postid, 'locators', true );

        $branches_longitude = $locators['longitude'];
        $branches_latitude = $locators['latitude'];		

		if($i<=4)
		{
			$content .='<div class="col-md-3 location-block">
					<div class="well-block">
					  <h2>'.get_the_title( $postid ).'</h2>
					  <div class="contact-information">
						<div class="address-block">
						  <div class="icon"><i class="flaticon-big104"></i></div>
						  <p>'.$branches_address.'</p>
						</div>
						<a class="btn btn-primary hvr-sweep-to-right btn-sm" href="'.get_permalink($postid).'">'.esc_html__('View Details','physioplus').'</a> </div>
					</div>
					<!-- /.location-block--> 
				  </div>';
		}

		$google_map_arr.='["'.get_the_title().'", '.$branches_latitude.', '.$branches_longitude.','.$i++.'],';	
		endwhile;
		wp_reset_postdata();
	}
	$script='<script>
var beaches = ['.$google_map_arr.'];
var marker_img = "'.get_template_directory_uri().'/images/marker.png";';
if(function_exists('thegenius_get_option'))
{
	$script.='var center_point =  {"lat":'.thegenius_get_option('branches_center_point_lat').',"lng":'.thegenius_get_option('branches_center_point_lng').'};';
}
else{
	$script.='var center_point =  {"lat":0,"lng":0};';
}
$script.='</script>';	

    return  do_shortcode(sprintf('<div class="section-space section-color"><div class="container">%s</div>
<div class="container-fluid">
    <div class="row">
      <div class="col-md-12 location-map">
        <div class="map" id="googleMap"> </div>
      </div>
    </div>
  </div>
  <div class="container">
	<div class="row location-thumbs">%s </div></div></div></div>%s',$title_html, $content,$script));
	
}

function branches_shortcode_scripts() {
    global $post;
    if( is_a( $post, 'WP_Post' ) && has_shortcode( $post->post_content, 'branches-block') ) {
		wp_enqueue_script( 'dcsnt', 'https://maps.googleapis.com/maps/api/js?key=AIzaSyDzeSbQwOp79SShN11MjCMtFsxDM7JqAQg', array(), null, true);
		wp_enqueue_script( 'physioplus-google-map-load', get_template_directory_uri() . '/js/google-map.js', array(), null, true);	
	
    }
}
add_action( 'wp_enqueue_scripts', 'branches_shortcode_scripts');



/********************************************/
/*
/*    testimonial boxes block shortcode.
/*
/********************************************/

add_shortcode( 'testimonial-boxes-block', 'physio_plugin_sc_testimonial_boxes_block' );
function physio_plugin_sc_testimonial_boxes_block($atts)
{
	$atts = shortcode_atts( array(
      "title" => false,
      "sub-title" => false,	 
      "details" => false,	 	   
	), $atts );

	if(isset($atts['title']))
	{
		$title = isset($atts['title']) ? $atts['title'] : '';
		$sub_title = isset($atts['sub-title']) ? $atts['sub-title'] : '';
		$details = isset($atts['details']) ? $atts['details'] : '';
		
		$title_html='<div class="row">
			  <div class="col-md-5">
				<h1>'.$title.'</h1>
				<h5 class="small-title left">'.$sub_title.'</h5>
			  </div>
			  <div class="col-md-7">
				<p class="lead">'.$details.'</p>
			  </div>
			</div>';
	}
	else{
		$title_html='';
	}
		
	$args = array( 'post_type' => 'testimonial' , 'posts_per_page' => -1 , 'orderby' => 'menu_order ID','order' => 'ASC','post_status'=> 'publish' );
	$testimonial = new WP_Query( $args );

	$content= '';
	if($testimonial->have_posts())		
	{
		while ( $testimonial->have_posts() ) : $testimonial->the_post();
		
		$postid = get_the_ID();
		
		$treatment_html='';
		if(get_post_meta( $postid, 'testimonials_treatment', true ))
		{
			$treatment_html=' ('.get_post_meta( $postid, 'testimonials_treatment', true ).')';
		}
		$content .='<div class="item col-md-12">
            <div class="testimonial-well">
              <div class="testimonial-desc">“'.get_post_meta( $postid, 'testimonials_details', true ).'”</div>
            </div>
            <div class="testimonial-author">
              <h3 class="patient-title">'.get_the_title( $postid ).'<span>'.$treatment_html.'</span></h3>
            </div>
          </div>';

		endwhile;
		wp_reset_postdata();
	}
    return  do_shortcode(sprintf('<div class="section-space section-color"><div class="container">%s<div class="row"><div class="col-md-12 testimonial-section"><div id="testimonial" class="row testimonial-box">%s </div></div></div></div></div>',$title_html, $content));		
}



/********************************************/
/*
/*    testimonial boxes block shortcode.
/*
/********************************************/

add_shortcode( 'testimonial-parallax', 'physio_plugin_sc_testimonial_parallax' );
function physio_plugin_sc_testimonial_parallax($atts)
{
	$args = array( 'post_type' => 'testimonial' , 'posts_per_page' => -1 , 'orderby' => 'menu_order ID','order' => 'ASC','post_status'=> 'publish' );
	$testimonial = new WP_Query( $args );

	$content= '';
	if($testimonial->have_posts())		
	{
		while ( $testimonial->have_posts() ) : $testimonial->the_post();
		
		$postid = get_the_ID();
		
		$treatment_html='';
		if(get_post_meta( $postid, 'testimonials_treatment', true ))
		{
			$treatment_html=' ('.get_post_meta( $postid, 'testimonials_treatment', true ).')';
		}
		  
		$content .= '<div class="item col-md-12 testimonial-wide">
            <div class="row">
              <div class="col-md-3 testimonial-pic">'.get_the_post_thumbnail($postid,'full',array('class'=>'img-responsive img-radius')).'</div>
              <div class="col-md-9 testimonial-content">
                <div class="testimonial-desc">“'.get_post_meta( $postid, 'testimonials_details', true ).'”</div>
                <div class="testimonial-author">
                  <h3 class="patient-title">'.get_the_title( $postid ).'<span>'.$treatment_html.'</span></h3>
                </div>
              </div>
            </div>
          </div>';

		endwhile;
		wp_reset_postdata();
	}
    return  do_shortcode(sprintf('<div class="testimonial-bg"><div class="container"><div class="row"><div class="col-md-offset-1 col-md-10 testimonial-section"><div id="testimonial-single" class="row testimonial-single">%s </div></div></div></div></div>', $content));		
}


/********************************************/
/*
/*    Doctor -block shorcode.
/*
/********************************************/

add_shortcode( 'therapist-block', 'physio_plugin_sc_therapist_block' );
function physio_plugin_sc_therapist_block($atts)
{
	$atts = shortcode_atts( array(
      "title" => false,
      "sub-title" => false,	 
      "details" => false,	 	   
	), $atts );


	if(isset($atts['title']))
	{
		$title = isset($atts['title']) ? $atts['title'] : '';
		$sub_title = isset($atts['sub-title']) ? $atts['sub-title'] : '';
		$details = isset($atts['details']) ? $atts['details'] : '';
		
		$title_html='<div class="row">
			  <div class="col-md-5 section-title">
				<h1>'.$title.'</h1>
				<h5 class="small-title left">'.$sub_title.'</h5>
			  </div>
			  <div class="col-md-7">
				<p class="lead">'.$details.'</p>
			  </div>
			</div>';
	}
	else{
		$title_html='';
	}

    $args = array( 'post_type' => 'therapist', 'posts_per_page' => 4,'post_parent' => 0,'orderby' => 'menu_order ID','order'   => 'ASC' );
	$therapist = new WP_Query( $args );

	$content= '';

	while ( $therapist->have_posts() ) : $therapist->the_post();
	
	$postid = get_the_ID();

	$meta_therapist_designation = get_post_meta( $postid , 'therapist_designation', true );
	if($meta_therapist_designation)
	{
		 $therapist_designation_html = '<span class="trainer-meta">'.esc_html($meta_therapist_designation).'</span>';
	}
	else
	{
		$therapist_designation_html='';
	}

	
	$content .='<div class="col-md-3 trainer-block">
        <div class="trainer-pic zoom-pic"> <a href="'.get_permalink($postid).'">'.get_the_post_thumbnail($postid,'full',array('class'=>'img-responsive')).'</a></div>
        <div class="trainer-caption">
          <h2><a class="trainer-title" href="'.get_permalink($postid).'">'.get_the_title($postid).'</a></h2>
          '.$therapist_designation_html.'</div>
      </div>';


	endwhile;
	wp_reset_postdata();		

    return  do_shortcode(sprintf('<div class="section-space"><div class="container">%s<div class="row">%s </div></div></div>',$title_html , $content));		
}

/********************************************/
/*
/*		Services Three Slide Block.
/*
/********************************************/

add_shortcode( 'services-three-slide', 'physioplus_plugin_sc_services_three_slide' );
function physioplus_plugin_sc_services_three_slide( $atts, $content ){	   

	$atts = shortcode_atts( array(
      "title" => false,
      "sub-title" => false,	 
      "details" => false,	 	   
	), $atts );


	if(isset($atts['title']))
	{
		$title = isset($atts['title']) ? $atts['title'] : '';
		$sub_title = isset($atts['sub-title']) ? $atts['sub-title'] : '';
		$details = isset($atts['details']) ? $atts['details'] : '';
		
		$title_html='<div class="row">
			  <div class="col-md-5 section-title">
				<h1>'.$title.'</h1>
				<h5 class="small-title left">'.$sub_title.'</h5>
			  </div>
			  <div class="col-md-7">
				<p class="lead">'.$details.'</p>
			  </div>
			</div>';
	}
	else{
		$title_html='';
	}

	$args = array( 'post_type' => 'service','posts_per_page' => -1,'orderby' => 'menu_order ID','order'   => 'ASC');	
	$service = new WP_Query( $args );

	$content= '';

	if($service->have_posts())	
	{
		while ( $service->have_posts() ) : $service->the_post();
		
		$postid = get_the_ID();

		$content .='<div class="col-md-12 service-thumbnail item"><!--service-thumnnail-->
          <div class="service-img zoom-pic"><a href="'.get_permalink($postid).'">'.get_the_post_thumbnail($postid,'full',array('class'=>'img-responsive')).'</a></div>
          <div class="service-content">
            <h2>'.get_the_title().'</h2>
            <p>'.get_the_excerpt().'</p>
          </div>
        </div>';

		endwhile;
		wp_reset_postdata();		
	}

    return  do_shortcode(sprintf('<div class="section-space section-color"><div class="container">%s<div class="row"><div class="service-thumbnail" id="service-thumbnail">%s</div></div></div></div>', $title_html, $content));		
}



/********************************************/
/*
/*		Services Block Slide 
/*
/********************************************/

add_shortcode( 'services-block-slide', 'physioplus_plugin_sc_services_block_slide' );
function physioplus_plugin_sc_services_block_slide( $atts, $content ){	   

	$atts = shortcode_atts( array(
      "title" => false,
      "sub-title" => false,	 
      "details" => false,	 	   
	), $atts );


	if(isset($atts['title']))
	{
		$title = isset($atts['title']) ? $atts['title'] : '';
		$sub_title = isset($atts['sub-title']) ? $atts['sub-title'] : '';
		$details = isset($atts['details']) ? $atts['details'] : '';
		
		$title_html='<div class="row">
			  <div class="col-md-5">
				<h1>'.$title.'</h1>
				<h5 class="small-title left">'.$sub_title.'</h5>
			  </div>
			  <div class="col-md-7">
				<p class="lead">'.$details.'</p>
			  </div>
			</div>';
	}
	else{
		$title_html='';
	}

	$args = array( 'post_type' => 'service','posts_per_page' => -1,'orderby' => 'menu_order ID','order'   => 'ASC');	
	$service = new WP_Query( $args );

	$content= "";
	if($service->have_posts())	
	{
		while ( $service->have_posts() ) : $service->the_post();
		
		$postid = get_the_ID();
 
		$content .='<div class="item">
          <div class="row">
            <div class="col-md-5 service-pic-block">
              <div class="service-pic zoom-pic"><a href="'.get_permalink($postid).'">'.get_the_post_thumbnail($postid,'full',array('class'=>'img-responsive')).'</a></div>
            </div>
            <div class="col-md-6 service-description">
              <h2><a href="'.get_permalink($postid).'" class="service-title">'.get_the_title().'</a></h2>
              <p>'.get_the_excerpt().'</p>
              <a href="'.get_permalink($postid).'" class="btn btn-default hvr-sweep-to-right">'.esc_html__('Read More','physioplus').'</a> </div>
          </div>
        </div>';

		endwhile;
		wp_reset_postdata();		
	}

    return  do_shortcode(sprintf('<div class="section-space">
  <div class="container">%s<div class="service-block">
      <div id="service" class="owl-carousel owl-theme">%s</div></div></div></div>',$title_html, $content));		
}

/********************************************/
/*
/*		overlay title
/*
/********************************************/

add_shortcode( 'site-title', 'physioplus_plugin_sc_site_title' );
function physioplus_plugin_sc_site_title( $atts){	

	$atts = shortcode_atts( array(
      "title" => false,	 
	  "sub-title" => false,	 
	  "details" => false,
	  "margin"=>false,	 
	), $atts );
	
	if($atts['margin']=="no")
	{
		$class='';
	}
	else
	{
		$class=' section-title';
	}

    return sprintf( 
      '<div class="row">
      <div class="col-md-5%s">
        <h1>%s</h1>
        <h5 class="small-title left">%s</h5>
      </div>
      <div class="col-md-7">
        <p class="lead">%s</p>
      </div>
    </div>',
	$class,
	$atts['title'],
	$atts['sub-title'],
	$atts['details']
    );
}

/********************************************/
/*
/*		CTA Parallax
/*
/********************************************/

add_shortcode( 'cta-parallax', 'physioplus_plugin_sc_cta_parallax' );
function physioplus_plugin_sc_cta_parallax( $atts){	

	$atts = shortcode_atts( array(
      "title" => false,	 
	  "details" => false,
	  "button_url" => false,	
	  "button_text" => false,
	), $atts );

    return sprintf( 
      '<div class="parallax-cta parallax parallax-2">
  <div class="container">
    <div class="row">
      <div class="col-md-offset-2 col-md-8">
        <h1>%s</h1>
        <p>%s</p>
        <a class="btn btn-default hvr-sweep-to-right" href="%s">%s</a> </div>
    </div>
  </div>
</div>',
		$atts['title'],
		$atts['details'],
		$atts['button_url'],
		$atts['button_text']

    );
}
?>